<?

class Utils{


    #construtor
    function Utils(){
    }

    #Funcao gerarNivelPagina
    #Objetivo: gerar uma string para ser usada no html, de modo a atingir o diretorio raiz do site
    #parametros: 
    #    intNivel: numero de subdiretorios a subir
    #retorno:
    #    strNivel: string para ser concatenada no html
    #Criada em: 28/03/2004
    #Ultima alterao: 28/03/2004
    #--------------------------------------------------------
    function gerarNivelPagina($intNivel){
        $strNivel = "";
        $intContador = 0;
    
        for($intContador = 0; $intContador < $intNivel; $intContador++){
            $strNivel .= "../";
        }
    
        return $strNivel;
    }

    #Funcao getForm
    #Objetivo: Recupera os dados do formulario, filtrando as aspas simples do conteudo;
    #          Esta funcao e uma evolucao da antiga FiltraSQL
    #parametros:
    #    campo: o nome do campo a recuperar
    #retorno: a string modificada recuperada do formulario
    #Criada em: 28/03/2004
    #Ultima alterao: 28/03/2004
    #--------------------------------------------------------
    function getForm($campo){
        if(isset($_REQUEST[$campo])){
            return str_replace("'", "''", $_REQUEST[$campo]);
        }
        else{
            return "";
        }
    }

    #Funcao dateFormatMySQL
    #Objetivo: formatar a data no padrao MySQL(YYYY-MM-DD)
    #parametros:
    #    oData: a data a converter, no formato dd/mm/yyyy
    #retorno: a data no formato MySQL
    #Criada em: 28/03/2004
    #Ultima alterao: 28/03/2004
    #--------------------------------------------------------
    function dateFormatMySQL($oData){
        $arrData = null; //armazenara o array da data de nasc
        $dt = ""; //armazenara a data ja no formato mysql

        $arrData = split("/", $oData);
        $dt = $arrData[2] . "-" . $arrData[1] . "-" . $arrData[0];        

        return $dt;
    }


    #Funcao dateFormatBr
    #Objetivo: formatar a data no padrao brasileiro(DD/MM/YYYY)
    #parametros:
    #    oData: a data a converter, no formato yyyy-mm-dd
    #retorno: a data no formato Br
    #Criada em: 28/03/2004
    #Ultima alterao: 28/03/2004
    #--------------------------------------------------------
    function dateFormatBr($oData){
        $arrData = null; //armazenara o array da data de nasc
        $dt = ""; //armazenara a data ja no formato mysql

        $arrData = split("-", $oData);
        $dt = $arrData[2] . "/" . $arrData[1] . "/" . $arrData[0];        

        return $dt;
    }


    #Funcao dateFormatBr2
    #Objetivo: formatar a data no padrao brasileiro com 2 digitos de ano(DD/MM/YY)
    #parametros:
    #    oData: a data a converter, no formato yyyy-mm-dd
    #retorno: a data no formato Br
    #Criada em: 28/03/2004
    #Ultima alterao: 28/03/2004
    #--------------------------------------------------------
    function dateFormatBr2($oData){
        $arrData = null; //armazenara o array da data de nasc
        $dt = ""; //armazenara a data ja no formato mysql

        $arrData = split("-", $oData);
        $dt = $arrData[2] . "/" . $arrData[1] . "/" . substr($arrData[0], 2, 2);

        return $dt;
    }


#Funcao dateFormatFrase
    #Objetivo: formatar a data no formato de frase
    #parametros:
    #    oData: a data a converter, no formato mm/dd/aaaa
    #retorno: a string com a frase
    #Criada em: 23/11/2005
    #Ultima altera?: 23/11/2005
    #--------------------------------------------------------
    function dateFormatFrase($oData){
        $oFrase = "";

        switch( date("w", strtotime($oData) ) ){
                case 1: $oFrase .= " Segunda-feira, ";
                        break;
                case 2: $oFrase .= " Tera-feira, ";
                        break;
                case 3: $oFrase .= " Quarta-feira, ";
                        break;
                case 4: $oFrase .= " Quinta-feira, ";
                        break;
                case 5: $oFrase .= " Sexta-feira, ";
                        break;
                case 6: $oFrase .= " Sbado, ";
                        break;
                case 7: $oFrase .= " Domingo, ";
                        break;
        }

        $oFrase .= date("d") . " de ";

        switch( date("n", strtotime($oData) ) ){
                case 1: $oFrase .= " janeiro, ";
                        break;
                case 2: $oFrase .= " fevereiro ";
                        break;
                case 3: $oFrase .= " maro ";
                        break;
                case 4: $oFrase .= " abril ";
                        break;
                case 5: $oFrase .= " maio ";
                        break;
                case 6: $oFrase .= " junho ";
                        break;
                case 7: $oFrase .= " julho ";
                        break;
                case 8: $oFrase .= " agosto ";
                        break;
                case 9: $oFrase .= " setembro ";
                        break;
                case 10: $oFrase .= " outubro ";
                        break;
                case 11: $oFrase .= " novembro ";
                        break;
                case 12: $oFrase .= " dezembro ";
                        break;
        }

        $oFrase .= " de " . date("Y");

        return $oFrase;
    }


    #Funcao criarThumbnail
    #Objetivo: cria o thumbnail da imagem indicada
    #parametros:
    #    oImg: caminho para a imagem original
    #    oThumb: caminho para o thumb
    #    oWidth: largura da imagem destino
    #    oHeight: altura da imagem destino
    #retorno: true se gerou, false em caso de erro
    #Criada em: 09/05/2006
    #Ultima alterao: 09/06/2006
    #Agradecimentos a Maurcio Massaia(_M) pelo cdigo de exemplo cedido
    #--------------------------------------------------------
    function criarThumbnail( $oImg, $oThumb, $oWidth, $oHeight ){
        $tmp_image=imagecreatefromjpeg( $oImg );
        $width = imagesx($tmp_image);
        $height = imagesy($tmp_image);

        $new_image = imagecreatetruecolor($oWidth,$oHeight);
        imagecopyresampled($new_image, $tmp_image,0,0,0,0, $oWidth, $oHeight, $width, $height);

        if ( imagejpeg ( $new_image, $oThumb, 75 ) ){
                return true;
        }
        else{
                return false;
        }
    }

}
?>