<?
	/**
	 ** A generic email sending class that can do HTML mail and include attachments
	 ** This class is copyright 2002 Ray A. Akey. All rights reserved.
	 ** This class may be redistributed provided all comments and notices remain intact.
	 ** @author Ray A. Akey (AKA HMetal)
	 ** @copyright 2002 Ray A. Akey   All rights reserved
	 **/
	class CodeMail
	{
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $subj;
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $from;
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $to;
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $reply_to;
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $headers;
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $headers_out;
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $body;
		/**
		 ** A private class field. Its type is string
		 ** @type String
		 **/
		var $body_out;
		/**
		 ** A private class field. Its type is boolean
		 ** @type Boolean
		 **/
		var $html_email = false;
		/**
		 ** A private class field. Its type is boolean
		 ** @type Boolean
		 **/
		var $pri = 3;

		/**
		 ** A private class field. Its type is boolean
		 ** @type array
		 **/
		var $attachments;

		/**
		 ** A private class field. Its type is boolean
		 ** @type Boolean
		 **/
		var $use_intmail = false;
		/**
		 ** A private class field. Its type is boolean
		 ** @type Boolean
		 **/
		var $mail_cmd = '/usr/sbin/sendmail -f';
		
		/**
		 ** A private class field. Its type is boolean
		 ** @type Boolean
		 **/
		var $mail_callback;
		
		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $MIME_HDR = "MIME-Version: 1.0\n";
		
		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $MIME_CT_HTML = "Content-Type: text/html; charset=iso-8859-1\n";

		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $MIME_CT_ATTACH = "Content-Type: multipart/mixed; boundary=";

		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $MIME_CT_TEXT_PLAIN = "Content-Type: text/plain; charset=iso-8859-1\n";

		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $MIME_ENCODING_PRINTABLE = "Content-Transfer-Encoding: quoted-printable\n";

		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $MIME_ENCODING_B64 = "Content-Transfer-Encoding: base64\n";

		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $MIME_DISPOSITION_ATTACH = "Content-disposition: attachment;\n";

		/**
		 ** A private class field. Its type is constant
		 ** @type String
		 **/
		var $boundary;

		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $PRI_URGENT = 1;
		/**
		 ** A private class field. Its type is constant
		 ** @type constant
		 **/
		var $PRI_NORMAL = 3;

		/**
		 ** constructor initializes some fields.
		 ** @returns void
		 **/
		function CodeMail()
		{
			$this->attachments = array();
			$this->pri = $this->PRI_NORMAL;
			$this->html_email = false;
			$this->use_intmail = false;
			$this->mail_cmd = '/usr/sbin/sendmail -f';
		}
		
		/**
		 ** Sets the string used as subject of the mail as displayed in the email client's subject field.
		 ** @returns void
		 ** @param $subj a string that will be used for the email's subject
		 **/
		function set_subject($subj)
		{
			$this->subj = $subj;
		}

		/**
		 ** If the class-internal mailer is used, this command is used to set the command to be used for sending the mail.&nbsp;Default is "/usr/sbin/sendmail -fi".
		 ** @returns void
		 ** @param $mail_cmd the command that will be used to send the email.&nbsp;You must specify the full path and arguments for the executable to use in sending the email.&nbsp;The default is "/usr/sbin/sendmail -f".
		 **/
		function set_mail_cmd($mail_cmd)
		{
			$this->mail_cmd = $mail_cmd;
		}

		/**
		 ** Sets the callback function. If this is set, then the callback function specified will be used to send the mail no matter if set_mail_command() is enabled. The callback function must accept 5 parameters. These are, in order of expectancy: $from, $to, $subject, $body, $headers
		 ** @returns void
		 ** @param $callback_function the (string) name of the function to be used as the sender function. The function must exist in global namespace.
		 **/
		function set_mail_callback($callback_function)
		{
			$this->mail_callback = $callback_function;
		}

		/**
		 ** Sets the string used as email sender.
		 ** @returns void
		 ** @param $from a string representing the user or email address from which the mail will appear to be sent.
		 **/
		function set_from($from)
		{
			$this->from = $from;
		}

		/**
		 ** Sets the intended recipient email address.
		 ** @returns void
		 ** @param $to the email address of the intended recipient.
		 **/
		function set_to($to)
		{
			$this->to = $to;
		}

		/**
		 ** clears or resets the "to" field. use set_to() to set
		 ** @returns void
		 **/
		function reset_to()
		{
			unset ($this->to);
		}

		/**
		 ** Sets the string used as the e-mail Reply-To field.
		 ** @returns void
		 ** @param $reply_to the email address of the user who should receive replies to the email.
		 **/
		function set_reply_to($reply_to)
		{
			$this->reply_to = $reply_to;
		}

		/**
		 ** Sets additional email (RFC-822) headers to be passed to the mailer.
		 ** @returns void
		 ** @param $headers a string containing any additional mail headers to be added to the message.&nbsp;Headers must follow RFC-822 format and each one separated by a newline (\n).
		 **/
		function set_headers($headers)
		{
			$this->headers = $headers;
		}

		/**
		 ** Sets the body of the email.&nbsp;May include HTML if email is to be sent as "MIME E-mail".
		 ** @returns void
		 ** @param $body The string to be used as the body of the email to be sent.
		 **/
		function set_body($body)
		{
			$this->body = $body;
		}

		/**
		 ** Flags the mail to be sent as HTML mail.&nbsp;Links in the body of the mail will appear as links in the recipient's browser.
		 ** @returns void
		 **/
		function set_html()
		{
			$this->html_email = true;
		}

		/**
		 ** e-mail is flagged as an urgent message.
		 ** @returns void
		 **/
		function set_urgent()
		{
			$this->pri = $this->PRI_URGENT;
		}
		
		/**
		 ** Sets the email to be a normal message -- this is the antedote to set_urgent.
		 ** @returns void
		 **/
		function set_normal()
		{
			$this->pri = $this->PRI_NORMAL;
		}
		
		/**
		 ** Use the internal email command, which uses a server-side mail client, command or MTA to send the mail.&nbsp;Use the set_mail_cmd to configure the mail command.
		 ** @returns void
		 **/
		function set_internal_mail()
		{
			$this->use_intmail = true;
		}
		
		/**
		 ** clears or resets the "attachments" field. use attach() to add an attachment
		 ** @returns void
		 **/
		function attach_reset()
		{
			unset ($this->attachments);
			$this->attachments = array();
		}

		/**
		 ** Adds a file to be attached to the email.&nbsp;argument must be the full path and filename of the file to attach.&nbsp;May be called repeatedly to add multiple files.&nbsp;Files are verified as existant before attaching.
		 ** @returns void
		 ** @param $filepath the full local machine path of the file to be attached to the email. This function may be called more than once to attach multiple files.
		 **/
		function attach($filepath)
		{
			if(file_exists($filepath))
			{
				$this->attachments[] = $filepath;
				return true;
			}
			return false;
		}

		/**
		 ** Prepares the email headers for the final email. Handles HTML mail and attachments preparation.
		 ** @returns void
		 **/
		function prep_headers()
		{
			$attach_files = count($this->attachments);
			$this->headers_out = "From: ".$this->from."\n";
			//$this->headers_out .= "To: ".$this->to."\n";
			if($this->reply_to)
				$this->headers_out .= "Reply-To: ".$this->reply_to."\n";
			$this->headers_out .= "Subject: ".$this->subj."\n";
			if($attach_files)
			{
				$this->headers_out .= $this->MIME_HDR;
				$this->headers_out .= $this->MIME_CT_ATTACH.'"'.$this->boundary."\"\n";
			}
			else if($this->html_email)
			{
				$this->headers_out .= $this->MIME_HDR;
				$this->headers_out .= $this->MIME_CT_HTML;
			}
			$this->headers_out .= "X-Priority: ".$this->pri."\n";
			$this->headers_out .= $this->headers."\n";
			if($attach_files)
			{
				$this->headers_out .= "This is a multi-part message in MIME format\n\n";
				$this->headers_out .= "--".$this->boundary."\n";
				if($this->html_email)
				{
					$this->headers_out .= $this->MIME_HDR;
					$this->headers_out .= $this->MIME_CT_HTML;
				}
				else
				{
					$this->headers_out .= $this->MIME_CT_TEXT_PLAIN;
					$this->headers_out .= $this->MIME_ENCODING_PRINTABLE."\n";
				}
			}
			$this->headers_out .= "\n";
		}

		/**
		 ** Prepares and formats the body for the final email. Handles HTML mail and attachments preparation.
		 ** @returns void
		 **/
		function prep_body()
		{
			$attach_files = count($this->attachments);
			$this->body_out = $this->body;
			$this->body_out .= "\n\n";
			if($attach_files)
			{
				while(list($k,$file) = each($this->attachments))
				{
					// read and base64 encode the attachment
					$size = filesize($file);
					if($fap = fopen($file,"r"))
					{
						$content = fread($fap, $size);
						$content = chunk_split(base64_encode($content));
						fclose($fap);

						// we should set a proper Content-Type by examining either the extension (minimum)
						// or by examining the file contents (lengthy operation).
						// for brevity, we'll just set the type as application/octet-stream and
						// leave the MIME type setting as an exercise for the user.
						$this->body_out .= "--".$this->boundary."\n";
						$this->body_out .= "Content-Type: application/pdf; \n";
						$this->body_out .= "	name: \"extrato.pdf\" \n";

						$this->body_out .= $this->MIME_DISPOSITION_ATTACH;
						$this->body_out .= "	filename=\"extrato.pdf\"\n";
						$this->body_out .= $this->MIME_ENCODING_B64."\n";
						
						// insert the encoded contents here
						// $this->body_out .= "name: \"aa.pdf\" \n";
						$this->body_out .= $content;
	
					}
				}
				// write final boundary
				$this->body_out .= "\n\n--".$this->boundary."--\n";
			}
		}

		/**
		 ** Returns the body for the final email. Handles HTML mail and attachments preparation.
		 ** @returns void
		 ** @param $prep if true, forces a call to prep_body before returning.
		 **/
		function get_body_out($prep = false)
		{
			if(prep)
				$this->prep_body();
			return $this->body_out;
		}

		/**
		 ** Prepares and formats the body for the final email. Handles HTML mail and attachments preparation.
		 ** @returns void
		 ** @param $prep if true, forces a call to prep_headers before returning.
		 **/
		function get_headers_out($prep = false)
		{
			if(prep)
				$this->prep_headers();
			return $this->headers_out;
		}
		
		/**
		 ** Sends mail using the familiar PHP mail() command syntax.
		 ** @returns void
		 ** @param $to the email address of the intended recipient.
		 ** @param $subj a string that will be used for the email's subject.
		 ** @param $body The string to be used as the body of the email to be sent.
		 ** @param $headers a string containing any additional mail headers to be added to the message.&nbsp;Headers must follow RFC-822 format and each one separated by a newline (\n).
		 **/
		function mail($to, $subj, $body, $headers = '')
		{
			$this->set_to($to);
			$this->set_subject($subj);
			$this->set_body($body);
			
			if(!strstr($headers, "\r\n") && !strstr($headers, "\n") )
				$headers .= "\n";
			$this->set_headers($headers);
			$this->send();
		}

		/**
		 ** Sends an email using the previously set properties.
		 ** @returns int
		 ** @type bool
		 */
		function send()
		{
			$this->boundary = '--=NEXT_PART_'.md5(microtime().'CODEMAIL_CLASS');

			/**
			 ** FIRST PREP HEADERS
			 **/
			 $this->prep_headers();

			/**
			 ** THEN PREP BODY
			 **/
			 $this->prep_body();

			if($this->mail_callback)
			{
				/**
				 ** Send mail using the specified callback function
				 **/
				$func = $this->mail_callback;
				return $func($this->from, $this->to, $this->subj, $this->body_out, $this->headers_out);
			}
			else
			{
				if($this->use_intmail)
				{
					/**
					 ** Send mail using piped data to a user-specified command
					 **/
					if($fp = popen($this->mail_cmd.' '.$this->from.' '.$this->to,"w"))
					{
	
						/**
						 ** WRITE IT ALL TO THE OUTPUT STREAM (pipe)
						 **/
						fputs($fp, $this->headers_out);
						fputs($fp, $this->body_out);
						pclose($fp);
						$retval = true;
					}
					else
						$retval = false;
				}
				else
				{
					/**
					 ** Send mail using PHP's mail command
					 **/
					return mail($this->to, $this->subj, $this->body_out, $this->headers_out);
				}
			}
			return $retval;
		} 
	}
	
	/**
	 ** A simple extension of the CodeMail class that sends email only with HTML format enabled.
	 ** @author Ray A. Akey (AKA HMetal)
	 **/
	class HTMLMail extends CodeMail
	{
		/**
		 ** The constructor simply switches the class into HTML mail mode.
		 ** @returns void
		 **/
		function HTMLMail()
		{
			parent::set_html();
		}
	}
?>
